% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_utils.R
\name{bb_treemap}
\alias{bb_treemap}
\title{Treemap property for a Billboard.js chart}
\usage{
bb_treemap(bb, ...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{...}{See \url{https://naver.github.io/billboard.js/release/latest/doc/Options.html#.treemap}}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Treemap property for a Billboard.js chart
}
\examples{
library("billboarder")
data("mpg", package = "ggplot2")

billboarder() \%>\% 
  bb_treemapchart(mpg[, 1]) \%>\% 
  bb_treemap(label = list(show = TRUE, threshold = 0.03))\%>\% 
  bb_data(
    labels = list(colors = "#FFF")
  )
}
