% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_utils.R
\name{bb_tooltip}
\alias{bb_tooltip}
\title{Tooltip property for a Billboard.js chart}
\usage{
bb_tooltip(bb, ...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{...}{See \url{https://naver.github.io/billboard.js/release/latest/doc/Options.html#.tooltip}}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Tooltip property for a Billboard.js chart
}
\examples{
# Format tooltip
billboarder() \%>\% 
  bb_scatterplot(data = iris, x = "Sepal.Length", y = "Sepal.Width", group = "Species") \%>\% 
  bb_tooltip(
    format = list(
      # skip the title in tooltip
      title = htmlwidgets::JS("function() {return undefined;}"),
      name = htmlwidgets::JS("function(name, ratio, id, index) {return '';}"),
      value = htmlwidgets::JS("function(value, ratio, id, index) {return id;}")
    )
  )
}
