% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_helpers.R
\name{bb_piechart}
\alias{bb_piechart}
\title{Helper for creating a pie chart}
\usage{
bb_piechart(bb, data, ...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{data}{A \code{data.frame}, first column must contain labels and second values associated.}

\item{...}{Arguments for slot pie, \url{https://naver.github.io/billboard.js/release/latest/doc/Options.html#.pie}.}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Helper for creating a pie chart
}
\note{
This function can be used with \code{\link{billboarderProxy}} in shiny application.
}
\examples{
\dontrun{
stars <- data.frame(
  package = c("billboarder", "ggiraph", "officer", "shinyWidgets", "visNetwork"),
  stars = c(9, 177, 43, 44, 169)
)

billboarder() \%>\% 
  bb_piechart(data = stars)
}
}
