% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bikm1_MLBM_Binary_functions.R
\name{CE_LBM}
\alias{CE_LBM}
\title{CE_LBM function for agreement between coclustering partitions}
\usage{
CE_LBM(z,w,zprime,wprime)
}
\arguments{
\item{z}{numeric vector  specifying the class of  rows.}

\item{w}{numeric vector  specifying the class of  columns.}

\item{zprime}{numeric vector  specifying another partition of  rows.}

\item{wprime}{numeric vector  specifying another partition of  columns.}
}
\value{
the value of the index
}
\description{
Produce a measure of agreement between two pairs of partitions for coclustering. A value of 1 means a perfect match.
}
\examples{
\donttest{require(bikm1)
require(bikm1)
set.seed(42)
z=floor(runif(4)*2)
zprime=floor(runif(4)*2)
w=floor(runif(4)*3)
wprime=floor(runif(4)*2)
error=CE_LBM(z,w,zprime,wprime)
}
}
