% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_forward.R
\name{fast_forward}
\alias{fast_forward}
\title{Fast-forward step}
\usage{
fast_forward(data, crit = bic, ..., maxf = 70)
}
\arguments{
\item{data}{an object of class \code{big}.}

\item{crit}{a function defining the model selection criterion. You can use
your own function or one of these: \code{bic}, \code{mbic}, \code{mbic2},
\code{aic}, \code{maic}, \code{maic2}.}

\item{...}{optional arguments to \code{crit}.}

\item{maxf}{a numeric, a maximal number of variables in the final model.}
}
\value{
An object of class \code{big}.
}
\description{
Add variables to a model as long as they reduce the given criterion.
Variables are searched according to \code{candidates} and every one which
reduces the criterion is added (not necessarily the best one).
}
\details{
Type \code{browseVignettes("bigstep")} for more details.
}
\examples{
set.seed(1)
n <- 30
p <- 10
X <- matrix(rnorm(n * p), ncol = p)
y <- X[, 2] + 2*X[, 3] - X[, 6] + rnorm(n)
d <- prepare_data(y, X)
fast_forward(d)
}
