% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitLogistic.R
\name{fitLogistic}
\alias{fitLogistic}
\title{Logistic regression}
\usage{
fitLogistic(X, y)
}
\arguments{
\item{X}{a numeric matrix.}

\item{y}{a numeric vector.}
}
\value{
A number, the log-likelihood.
}
\description{
Fit the logistic regression model and calculate the log-likelihood.
}
\examples{
set.seed(1)
n <- 100
M <- 10
X <- matrix(rnorm(M*n), ncol=M)
mu <- X[, 2] - X[, 3] + X[, 6] - X[, 10]
p <- 1/(1 + exp(-mu))
y <- rbinom(n, 1, p)
fitLogistic(X, y)
}

