% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.big_sp}
\alias{predict.big_sp}
\title{Predict method}
\usage{
\method{predict}{big_sp}(object, X, ind.row = rows_along(X),
  covar.row = NULL, block.size = block_size(nrow(X)), ...)
}
\arguments{
\item{object}{Object of class \code{big_sp}.}

\item{X}{A \link[=FBM-class]{FBM}.}

\item{ind.row}{An optional vector of the row indices that are used.
If not specified, all rows are used. \strong{Don't use negative indices.}}

\item{covar.row}{Matrix of covariables to be added in each model to correct
for confounders (e.g. the scores of PCA), corresponding to \code{ind.row}.
Default is \code{NULL} and corresponds to only adding an intercept to each model.}

\item{block.size}{Maximum number of columns read at once.
Default uses \link{block_size}.}

\item{...}{Not used.}
}
\value{
A matrix of scores, with rows corresponding to \code{ind.row}
and columns corresponding to \code{lambda}.
}
\description{
Predict method for class \code{big_sp}.
}
\examples{
# simulating some data
N <- 73
M <- 430
X <- FBM(N, M, init = rnorm(N * M, sd = 5))
y <- sample(0:1, size = N, replace = TRUE)
covar <- matrix(rnorm(N * 3), N)

ind.train <- sort(sample(N, N/2))
mod <- big_spLogReg(X, y[ind.train], ind.train = ind.train,
                    covar.train = covar[ind.train, ])
ind.test <- setdiff(rows_along(X), ind.train)
pred <- predict(mod, X = X, ind.row = ind.test,
                covar.row = covar[ind.test, ])
}
\seealso{
\link{big_spLinReg}, \link{big_spLogReg} and \link{big_spSVM}.
}
