% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biglasso.R
\name{COPY_biglasso}
\alias{COPY_biglasso}
\title{Sparse regression path}
\usage{
COPY_biglasso(X, y.train, ind.train, covar.train, family = c("gaussian",
  "binomial"), alpha = 1, lambda.min = if (nrow(X) > ncol(X)) 0.001 else
  0.01, nlambda = 100, lambda.log.scale = TRUE, lambda, eps = 1e-07,
  max.iter = 1000, dfmax = p + 1, penalty.factor = NULL, warn = TRUE,
  verbose = FALSE)
}
\arguments{
\item{family}{Either "gaussian" or "binomial", depending on the response.}

\item{alpha}{The elastic-net mixing parameter that controls the relative
contribution from the lasso (l1) and the ridge (l2) penalty. The penalty is
defined as \deqn{ \alpha||\beta||_1 + (1-\alpha)/2||\beta||_2^2.}
\code{alpha = 1} is the lasso penalty and \code{alpha} in between \code{0}
(\code{1e-6}) and \code{1} is the elastic-net penalty.}

\item{lambda.min}{The smallest value for lambda, as a fraction of
lambda.max. Default is \code{.001} if the number of observations is larger than
the number of covariates and \code{.01} otherwise.}

\item{nlambda}{The number of lambda values. Default is \code{100}.}

\item{lambda.log.scale}{Whether compute the grid values of lambda on log
scale (default) or linear scale.}

\item{lambda}{A user-specified sequence of lambda values. By default, a
sequence of values of length \code{nlambda} is computed, equally spaced on
the log scale.}

\item{eps}{Convergence threshold for inner coordinate descent.
The algorithm iterates until the maximum change in the objective after any
coefficient update is less than \code{eps} times the null deviance.
Default value is \code{1e-7}.}

\item{max.iter}{Maximum number of iterations. Default is \code{1000}.}

\item{dfmax}{Upper bound for the number of nonzero coefficients. Default is
no upper bound. However, for large data sets, computational burden may be
heavy for models with a large number of nonzero coefficients.}

\item{penalty.factor}{A multiplicative factor for the penalty applied to
each coefficient. If supplied, \code{penalty.factor} must be a numeric
vector of length equal to sum of the number of columns of \code{X} and the
number of covariables (intercept excluded). The purpose of \code{penalty.factor}
is to apply differential penalization if some coefficients are thought to be
more likely than others to be in the model. Current package doesn't allow
unpenalized coefficients. That is \code{penalty.factor} cannot be 0.}

\item{warn}{Return warning messages for failures to converge and model
saturation? Default is \code{TRUE}.}

\item{verbose}{Whether to print out the start, the timing of each lambda
iteration and the end. Default is \code{FALSE}.}
}
\value{
A named list with following variables:
\item{intercept}{A vector of intercepts, corresponding to each lambda.}
\item{beta}{The fitted matrix of coefficients, store in sparse matrix
representation. The number of rows is equal to the number of
coefficients, and the number of columns is equal to \code{nlambda}.}
\item{iter}{A vector of length \code{nlambda} containing the number of
iterations until convergence at each value of \code{lambda}.}
\item{lambda}{The sequence of regularization parameter values in the path.}
\item{penalty}{Penalty used. See the input parameter \code{alpha}.}
\item{family}{Either \code{"gaussian"} or \code{"binomial"} depending on the
function used.}
\item{alpha}{Input parameter.}
\item{loss}{A vector containing either the residual sum of squares
(for linear models) or negative log-likelihood (for logistic models)
of the fitted model at each value of \code{lambda}.}
\item{penalty.factor}{Input parameter.}
\item{n}{The number of observations used in the model fitting. It's equal
to \code{length(row.idx)}.}
\item{p}{The number of dimensions (including covariables,
but not the intercept).}
\item{center}{The sample mean vector of the variables, i.e., column mean
of the sub-matrix of \code{X} used for model fitting.}
\item{scale}{The sample standard deviation of the variables, i.e.,
column standard deviation of the sub-matrix of \code{X} used for model
fitting.}
\item{y}{The response vector used in the model fitting. Depending on
\code{row.idx}, it could be a subset of the raw input of the response vector
y.}
\item{col.idx}{The indices of features that have 'scale' value greater
than \code{1e-6}. Features with 'scale' less than 1e-6 are removed from
model fitting.}
\item{rejections}{The number of features rejected at each value of
\code{lambda}.}
}
\description{
Fit solution paths for linear or logistic regression models penalized by
lasso (alpha = 1) or elastic-net (1e-6 < alpha < 1) over a grid of values
for the regularization parameter lambda.
}
\details{
The objective function for linear regression (\code{family = "gaussian"}) is
\deqn{\frac{1}{2n}\textrm{RSS} + \textrm{penalty},} for logistic regression
(\code{family = "binomial"}) it is \deqn{-\frac{1}{n} loglike +
\textrm{penalty}.}
}
\keyword{internal}
