% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readplink.R
\name{snp_attach}
\alias{snp_attach}
\title{Attach a "bigSNP" from backing files}
\usage{
snp_attach(rdsfile)
}
\arguments{
\item{rdsfile}{The path of the ".rds" which stores the \code{bigSNP} object.}
}
\value{
The \code{bigSNP} object.
}
\description{
Load a \link[=bigSNP-class]{bigSNP} from backing files into R.
}
\details{
This is often just a call to \link{readRDS}. But it also checks if you have moved
the two (".bk" and ".rds") backing files to another directory.
}
\examples{
(bedfile <- system.file("extdata", "example.bed", package = "bigsnpr"))

# Reading the bedfile and storing the data in temporary directory
rds <- snp_readBed(bedfile, backingfile = tempfile())

# Loading the data from backing files
test <- snp_attach(rds)

str(test)
dim(G <- test$genotypes)
G[1:8, 1:8]
}
