% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-save-infos.R
\name{snp_save}
\alias{snp_save}
\title{Save modifications}
\usage{
snp_save(x)
}
\arguments{
\item{x}{A \link[=bigSNP-class]{bigSNP}.}
}
\value{
The (saved) \code{bigSNP}.
}
\description{
Save a \code{bigSNP} after having made some modifications to it.
As \code{bigSNP} is an S3 class, you can add any slot you want
to an object of this class, then use \code{snp_save} to
save these modifications in the corresponding ".rds" backing file.
}
\examples{
set.seed(1)

# Reading example
test <- snp_attachExtdata()

# I can add whatever I want to an S3 class
test$map$`p-values` <- runif(nrow(test$map))
str(test$map)

# Reading again
test.savedIn <- sub("\\\\.bk$", ".rds", test$genotypes$backingfile)
test2 <- snp_attach(rdsfile = test.savedIn)
str(test2$map) # new slot wasn't saved

# Save it
test <- snp_save(test)

# Reading again
test3 <- snp_attach(rdsfile = test.savedIn)
str(test3$map) # it is saved now

# The complicated code of this function
snp_save
}
