% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigsnpr.R
\docType{package}
\name{bigsnpr-package}
\alias{bigsnpr}
\alias{bigsnpr-package}
\title{bigsnpr: Analysis of Massive SNP Arrays}
\arguments{
\item{G}{A \link[=FBM.code256-class]{FBM.code256}
(typically \code{<bigSNP>$genotypes}).\cr
\strong{You shouldn't have missing values in your data or SNPs with 0 MAF.}}

\item{Gna}{A \link[=FBM.code256-class]{FBM.code256}
(typically \code{<bigSNP>$genotypes}).\cr
You can have missing values in your data.}

\item{x}{A \link[=bigSNP-class]{bigSNP}.}

\item{infos.chr}{Vector of integers specifying each SNP's chromosome.\cr
Typically \code{<bigSNP>$map$chromosome}.}

\item{infos.pos}{Vector of integers specifying the physical position
on a chromosome (in base pairs) of each SNP.\cr
Typically \code{<bigSNP>$map$physical.pos}.}

\item{nploidy}{Number of trials, parameter of the binomial distribution.
Default is \code{2}, which corresponds to diploidy, such as for the human genome.}

\item{ind.row}{An optional vector of the row indices (individuals) that
are used. If not specified, all rows are used.\cr
\strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices (SNPs) that are used.
If not specified, all columns are used.\cr
\strong{Don't use negative indices.}}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}
}
\description{
Easy-to-use, efficient, flexible and scalable tools
for the analysis of massive SNP arrays.
Preprint: Privé et al. (2017) <doi:10.1101/190926>.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://privefl.github.io/bigsnpr}
  \item Report bugs at \url{https://github.com/privefl/bigsnpr/issues}
}

}
\author{
\strong{Maintainer}: Florian Privé \email{florian.prive.21@gmail.com}

Other contributors:
\itemize{
  \item Michael Blum \email{michael.blum@univ-grenoble-alpes.fr} [thesis advisor]
  \item Hugues Aschard \email{hugues.aschard@pasteur.fr} [thesis advisor]
}

}
