% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi.R
\name{DBI}
\alias{DBI}
\alias{dbFetch,BigQueryResult-method}
\alias{dbReadTable,BigQueryConnection,character-method}
\title{DBI methods}
\usage{
\S4method{dbFetch}{BigQueryResult}(res, n = -1, ...)

\S4method{dbReadTable}{BigQueryConnection,character}(conn, name, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}, created by
\code{\link[DBI:dbSendQuery]{dbSendQuery()}}.}

\item{n}{maximum number of records to retrieve per fetch. Use \code{n = -1}
or \code{n = Inf}
to retrieve all pending records.  Some implementations may recognize other
special values.}

\item{...}{Other arguments passed on to methods.}

\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}
}
\value{
Returns a tibble.
}
\description{
Implementations of pure virtual functions defined in the \code{DBI} package.
}
\keyword{internal}
