% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old-job-upload.R
\name{insert_upload_job}
\alias{insert_upload_job}
\title{Create a new upload job \link{deprecated}}
\usage{
insert_upload_job(project, dataset, table, values, billing = project,
  create_disposition = "CREATE_IF_NEEDED",
  write_disposition = "WRITE_APPEND", ...)
}
\arguments{
\item{project, dataset}{Project and dataset identifiers}

\item{table}{name of table to insert values into}

\item{values}{data frame of data to upload}

\item{billing}{project ID to use for billing}

\item{create_disposition}{behavior for table creation if the destination
already exists. defaults to \code{"CREATE_IF_NEEDED"},
the only other supported value is \code{"CREATE_NEVER"}; see
\href{https://cloud.google.com/bigquery/docs/reference/v2/jobs#configuration.load.createDisposition}{the API documentation}
for more information}

\item{write_disposition}{behavior for writing data if the destination already
exists. defaults to \code{"WRITE_APPEND"}, other possible values are
\code{"WRITE_TRUNCATE"} and \code{"WRITE_EMPTY"}; see
\href{https://cloud.google.com/bigquery/docs/reference/v2/jobs#configuration.load.writeDisposition}{the API documentation}
for more information}

\item{...}{Additional arguments passed on to the underlying API call.
snake_case names are automatically converted to camelCase.}
}
\description{
Please use \link{api-job} instead.
}
\examples{
\dontrun{
list_datasets(bq_test_project)
list_tables("193487687779", "houston")
job <- insert_upload_job("193487687779", "houston", "mtcars", mtcars)
wait_for(job)
list_tables("193487687779", "houston")
delete_table("193487687779", "houston", "mtcars")
}
}
\seealso{
Google API documentation:
\url{https://developers.google.com/bigquery/loading-data-into-bigquery#loaddatapostrequest}

Other jobs: \code{\link{get_job}},
  \code{\link{insert_extract_job}},
  \code{\link{insert_query_job}}, \code{\link{wait_for}}
}
\keyword{internal}
