% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteorological_variables.r
\name{wetbulb.solver}
\alias{wetbulb.solver}
\title{Solver Function for Wet-Bulb Temperature}
\usage{
wetbulb.solver(
  ea,
  Tair,
  gamma,
  accuracy,
  Esat.formula,
  constants = bigleaf.constants()
)
}
\arguments{
\item{ea}{Air vapor pressure (kPa)}

\item{Tair}{Air temperature (degC)}

\item{gamma}{Psychrometric constant (kPa K-1)}

\item{accuracy}{Accuracy of the result (degC)}

\item{Esat.formula}{Optional: formula to be used for the calculation of esat and the slope of esat.
One of \code{"Sonntag_1990"} (Default), \code{"Alduchov_1996"}, or \code{"Allen_1998"}.
See \code{\link{Esat.slope}}.}

\item{constants}{Pa2kPa - conversion pascal (Pa) to kilopascal (kPa)
Le067 - Lewis number for water vapor to the power of 0.67}
}
\description{
Solver function used in wetbulb.temp()
}
\note{
Arguments \code{accuracy} and \code{Esat.formula} are passed to this function by wetbulb.temp().
}
\keyword{internal}
