% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit_conversions.r
\name{VPD.to.rH}
\alias{VPD.to.rH}
\alias{rH.to.VPD}
\alias{e.to.rH}
\alias{VPD.to.e}
\alias{e.to.VPD}
\alias{e.to.q}
\alias{q.to.e}
\alias{q.to.VPD}
\alias{VPD.to.q}
\title{Conversions between Humidity Measures}
\usage{
VPD.to.rH(
  VPD,
  Tair,
  Esat.formula = c("Sonntag_1990", "Alduchov_1996", "Allen_1998"),
  constants = bigleaf.constants()
)

rH.to.VPD(
  rH,
  Tair,
  Esat.formula = c("Sonntag_1990", "Alduchov_1996", "Allen_1998"),
  constants = bigleaf.constants()
)

e.to.rH(
  e,
  Tair,
  Esat.formula = c("Sonntag_1990", "Alduchov_1996", "Allen_1998"),
  constants = bigleaf.constants()
)

VPD.to.e(
  VPD,
  Tair,
  Esat.formula = c("Sonntag_1990", "Alduchov_1996", "Allen_1998"),
  constants = bigleaf.constants()
)

e.to.VPD(
  e,
  Tair,
  Esat.formula = c("Sonntag_1990", "Alduchov_1996", "Allen_1998"),
  constants = bigleaf.constants()
)

e.to.q(e, pressure, constants = bigleaf.constants())

q.to.e(q, pressure, constants = bigleaf.constants())

q.to.VPD(
  q,
  Tair,
  pressure,
  Esat.formula = c("Sonntag_1990", "Alduchov_1996", "Allen_1998"),
  constants = bigleaf.constants()
)

VPD.to.q(
  VPD,
  Tair,
  pressure,
  Esat.formula = c("Sonntag_1990", "Alduchov_1996", "Allen_1998"),
  constants = bigleaf.constants()
)
}
\arguments{
\item{VPD}{Vapor pressure deficit (kPa)}

\item{Tair}{Air temperature (deg C)}

\item{Esat.formula}{Optional: formula to be used for the calculation of esat and the slope of esat.
One of \code{"Sonntag_1990"} (Default), \code{"Alduchov_1996"}, or \code{"Allen_1998"}.
See \code{\link{Esat.slope}}.}

\item{constants}{eps - ratio of the molecular weight of water vapor to dry air (-) \cr
Pa2kPa - conversion pascal (Pa) to kilopascal (kPa)}

\item{rH}{Relative humidity (-)}

\item{e}{Vapor pressure (kPa)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{q}{Specific humidity (kg kg-1)}
}
\description{
Conversion between vapor pressure (e), vapor pressure deficit (VPD),
             specific humidity (q), and relative humidity (rH).
}
\references{
Foken, T, 2008: Micrometeorology. Springer, Berlin, Germany.
}
\concept{humidity conversion}
