% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evapotranspiration.r
\name{potential.ET}
\alias{potential.ET}
\title{Potential Evapotranspiration}
\usage{
potential.ET(data, Tair = "Tair", pressure = "pressure", Rn = "Rn",
  G = NULL, S = NULL, alpha = 1.26, missing.G.as.NA = FALSE,
  missing.S.as.NA = FALSE, Esat.formula = c("Sonntag_1990", "Alduchov_1996",
  "Allen_1998"), constants = bigleaf.constants())
}
\arguments{
\item{data}{Data.frame or matrix containing all required variables; optional}

\item{Tair}{Air temperature (deg C)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{Rn}{Net radiation (W m-2)}

\item{G}{Ground heat flux (W m-2); optional}

\item{S}{Sum of all storage fluxes (W m-2); optional}

\item{alpha}{Priestley-Taylor coefficient (-)}

\item{missing.G.as.NA}{if \code{TRUE}, missing G are treated as \code{NA}s, otherwise set to 0.}

\item{missing.S.as.NA}{if \code{TRUE}, missing S are treated as \code{NA}s, otherwise set to 0.}

\item{Esat.formula}{Optional: formula to be used for the calculation of esat and the slope of esat.
One of \code{"Sonntag_1990"} (Default), \code{"Alduchov_1996"}, or \code{"Allen_1998"}.
See \code{\link{Esat.slope}}.}

\item{constants}{cp - specific heat of air for constant pressure (J K-1 kg-1) \cr
eps - ratio of the molecular weight of water vapor to dry air (-)}
}
\value{
a data.frame with the following columns:
        \item{ET_pot}{Potential evapotranspiration (kg m-2 s-1)}
        \item{LE_pot}{Potential latent heat flux (W m-2)}
}
\description{
Potential evapotranspiration according to Priestley & Taylor 1972.
}
\details{
Potential evapotranspiration is calculated according to Priestley & Taylor, 1972:

           \deqn{LE_pot = (\alpha * \Delta * (Rn - G - S)) / (\Delta + \gamma)}

         \eqn{\alpha} is the Priestley-Taylor coefficient, \eqn{\Delta} is the slope 
         of the saturation vapor pressure curve (kPa K-1),
         and \eqn{\gamma} is the psychrometric constant (kPa K-1).
}
\note{
If the first argument \code{data} is provided (either a matrix or a data.frame),
      the following variables can be provided as character (in which case they are interpreted as
      the column name of \code{data}) or as numeric vectors, in which case they are taken
      directly for the calculations. If \code{data} is not provided, all input variables have to be
      numeric vectors.
}
\examples{
# Calculate potential ET from a surface that receives Rn of 400 Wm-2
potential.ET(Tair=30,pressure=100,Rn=400,alpha=1.26)    

}
\references{
Priestley, C.H.B., Taylor, R.J., 1972: On the assessment of surface heat flux
            and evaporation using large-scale parameters. Monthly Weather Review 100, 81-92.
}
\seealso{
\code{\link{reference.ET}}
}
