% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigleaf_physiology.r
\name{intercellular.CO2}
\alias{intercellular.CO2}
\title{Bulk Intercellular CO2 Concentration}
\usage{
intercellular.CO2(data, Ca = "Ca", GPP = "GPP", Gs = "Gs", Rleaf = NULL,
  calc.surface.CO2 = FALSE, Ga_CO2 = "Ga_CO2", NEE = "NEE",
  Tair = "Tair", pressure = "pressure", missing.Rleaf.as.NA = FALSE,
  constants = bigleaf.constants())
}
\arguments{
\item{data}{Data.Frame or matrix with all required columns}

\item{Ca}{Atmospheric CO2 concentration (umol mol-1)}

\item{GPP}{Gross primary productivity (umol CO2 m-2 s-1)}

\item{Gs}{Surface conductance to water vapor (mol m-2 s-1)}

\item{Rleaf}{Ecosystem respiration stemming from leaves (umol CO2 m-2 s-1); defaults to 0}

\item{calc.surface.CO2}{Should the derived surface CO2 concentration be used instead of 
measured atmospheric CO2? If \code{TRUE}, Ca is derived as shown in \code{Details}.}

\item{Ga_CO2}{Aerodynamic conductance to CO2 (m s-1)}

\item{NEE}{Net ecosystem exchange (umol CO2 m-2 s-1), negative values indicate CO2 uptake by the ecosystem}

\item{Tair}{Air temperature (degC); ignored if \code{calc.surface.CO2 = FALSE}.}

\item{pressure}{Atmospheric pressure (kPa); ignored if \code{calc.surface.CO2 = FALSE}.}

\item{missing.Rleaf.as.NA}{if Rleaf is provided, should missing values be treated as \code{NA} (\code{TRUE})
or set to 0 (\code{FALSE}, the default)?}

\item{constants}{DwDc - Ratio of the molecular diffusivities for water vapor and CO2 (-)}
}
\value{
\item{Ci -}{Bulk canopy intercellular CO2 concentration (umol mol-1)}
}
\description{
Bulk canopy intercellular CO2 concentration (Ci) calculated based on Fick's law
             given surface conductance (Gs), gross primary productivity (GPP) and 
             atmospheric CO2 concentration (Ca).
}
\details{
Bulk intercellular CO2 concentration (Ci) is given by:

           \deqn{Ci = Ca - (GPP - Rleaf)/(Gs/1.6)}
         
         where Gs/1.6 (mol m-2 s-1) represents the surface conductance to CO2.
         Note that Gs is required in mol m-2 s-1 for water vapor. Gs is converted to
         its value for CO2 internally.
}
\note{
The equation is based on Fick's law of diffusion and is equivalent to the
      often used equation at leaf level (ci = ca - An/gs).
      Note that GPP and Gs have a different interpretation than An and gs.
      Gs comprises non-physiological contributions (i.e. physical evaporation)
      and is confounded by physical factors (e.g. energy balance non-closure).
      GPP does not account for dark respiration and is further subject to uncertainties
      in the NEE partitioning algorithm used. Leaf respiration can be provided,
      but it is usually not known at ecosystem level (as a consequence, Ci is likely to be 
      slightly underestimated)
      This function should be used with care and the resulting Ci might not be
      readily comparable to its leaf-level analogue and/or physiological meaningful.
}
\examples{
# calculate bulk canopy Ci of a productive ecosystem
intercellular.CO2(Ca=400,GPP=40,Gs=0.7)

# now calculate bulk canopy Ci, but with Ca at the canopy surface (Ga and NEE are needed)
# The function aerodynamic.conductance() can be used to calculate Ga_CO2.
# Here, Ga_CO2 of 0.05 m s-1 is assumed.

intercellular.CO2(Ca=400,GPP=40,Gs=0.7,calc.surface.CO2=TRUE,Ga_CO2=0.05,NEE=-55,
                  Tair=25,pressure=100) 
# note the sign convention for NEE

}
\references{
Kosugi Y. et al., 2013: Determination of the gas exchange phenology in an
            evergreen coniferous forest from 7 years of eddy covariance flux data using
            an extended big-leaf analysis. Ecol Res 28, 373-385.
            
            Keenan T., Sabate S., Gracia C., 2010: The importance of mesophyll conductance in
            regulating forest ecosystem productivity during drought periods. Global Change Biology
            16, 1019-1034.
}
