% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans.R
\name{bigkmeans}
\alias{bigkmeans}
\title{Memory-efficient k-means cluster analysis}
\usage{
bigkmeans(x, centers, iter.max = 10, nstart = 1, dist = "euclid")
}
\arguments{
\item{x}{a \code{\link[bigmemory]{big.matrix}} object.}

\item{centers}{a scalar denoting the number of clusters, or for k clusters, 
a k by \code{ncol(x)} matrix.}

\item{iter.max}{the maximum number of iterations.}

\item{nstart}{number of random starts, to be done in parallel if there 
is a registered backend (see below).}

\item{dist}{the distance function. Can be "euclid" or "cosine".}
}
\value{
An object of class \code{kmeans}, just as produced by 
\code{\link{kmeans}}.
}
\description{
k-means cluster analysis without the memory overhead, and 
possibly in parallel using shared memory.
}
\details{
The real benefit is the lack of memory overhead compared to the 
standard \code{\link{kmeans}} function.  Part of the overhead from 
\code{kmeans()} stems from the way it looks for unique starting 
centers, and could be improved upon.  The \code{bigkmeans()} function 
works on either regular \R \code{matrix} objects, or on \code{big.matrix} 
objects.  In either case, it requires no extra memory (beyond the data, 
other than recording the cluster memberships), whereas \code{kmeans()} 
makes at least two extra copies of the data.  And \code{kmeans()} is even 
worse if multiple starts (\code{nstart>1}) are used.  If \code{nstart>1} 
and you are using \code{bigkmeans()} in parallel, a vector of cluster 
memberships will need to be stored for each worker, which could be 
memory-intensive for large data.  This isn't a problem if you use are running
the multiple starts sequentially.

Unless you have a really big data set (where a single run of 
\code{\link{kmeans}} not only burns memory but takes more than a few 
seconds), use of parallel computing for multiple random starts is unlikely 
to be much faster than running iteratively.

Only the algorithm by MacQueen is used here.
}
\note{
A comment should be made about the excellent package \pkg{foreach}.  By
default, it provides \code{\link[foreach]{foreach}}, which is used
much like a \code{for} loop, here over the \code{nstart}
and doing a final comparison of all results).

When a parallel backend has been registered (see packages \pkg{doSNOW}, 
\pkg{doMC}, and \pkg{doMPI}, for example), \code{bigkmeans()} automatically 
distributes the \code{nstart} random starting points across the available 
workers.  This is done in shared memory on an SMP, but is distributed on 
a cluster *IF* the \code{big.matrix} is file-backed.  If used on a cluster 
with an in-RAM \code{big.matrix}, it will fail horribly.  We're considering 
an extra option as an alternative to the current behavior.
}
