% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa.ls.bc.ci.R
\name{bfa.ls.bc.ci}
\alias{bfa.ls.bc.ci}
\title{Bias-Corrected Confidence intervals of Least Squares Estimators for Bifurcating
Autoregressive Models}
\usage{
bfa.ls.bc.ci(
  z,
  p,
  method = "BCa",
  conf.int = "standard.normal.bc",
  conf.level = 0.95,
  B = 5,
  burn = 5
)
}
\arguments{
\item{z}{a numeric vector containing the tree data}

\item{p}{an integer determining the order of bifurcating autoregressive model
to be fit to the data}

\item{method}{method of bias correction. Currently, "boot1", "boot2fast", and
"BCa" are supported and they implement single bootstrap, fast-double bootstrap,
and bias-corrected and accelerated bootstrap, respectively. Defaults to "BCa".}

\item{conf.int}{type of the confidence interval. Currently, "standard.normal.bc",
"percentile", and "percentile.bc" are supported and they implement corrected
standard normal bootstrap CI, uncorrected percentile bootstrap CI, and corrected
percentile bootstrap CI, respectively. If "boot1" method is selected, the
"standard.normal.bc", "percentile", "percentile.bc" confidence intervals can
be obtained. If "boot2fast" method is selected, the "standard.normal.bc" and
"percentile.bc" confidence intervals can be obtained. No effect for conf.int,
the "BCa" method is selected. Defaults to standard.normal.bc".}

\item{conf.level}{confidence level to be used in computing confidence intervals
for model coefficients. Defaults to \code{0.95}.}

\item{B}{number of bootstrap samples (replicates).}

\item{burn}{number of tree generations to discard before starting the
bootstrap sample (replicate). Defaults to 5.}
}
\value{
\item{Bias.corrected.coef}{a matrix containing the
bias-correction least squares estimates of the autoregressive coefficients}
\item{BCa.ci}{a matrix containing the lower and upper limits of corrected BCa
confidence intervals,if \code{method="BCa"}}
\item{standard.normal.bc.ci}{a matrix containing the lower and upper limits of
corrected confidence intervals, if \code{method="boot1"} and \code{conf.int="standard.normal.bc"}
or \code{conf.int="All"}}
\item{percentile.ci}{a matrix containing the lower and upper limits of uncorrected
percentile confidence intervals, if \code{method="boot1"} and \code{conf.int="percentile"}
or \code{conf.int="All"}}
\item{percentile.bc.ci}{a matrix containing the lower and upper limits of corrected
percentile confidence intervals, if \code{method="boot1"} and \code{conf.int="percentile.bc"}
or \code{conf.int="All"}}
\item{standard.normal.bc.ci}{a matrix containing the lower and upper limits of corrected
confidence intervals, if \code{method="boot2fast"} and \code{conf.int="standard.normal.bc"}
or \code{conf.int="All"}}
\item{percentile.bc.ci}{a matrix containing the lower and upper limits of corrected percentile
confidence intervals, if \code{method="boot2fast"} and \code{conf.int="percentile.bc"} or \code{conf.int="All"}}
}
\description{
This function performs bias correction confidence intervals on the least squares
estimators of the autoregressive coefficients in a BAR(p) model using single,
fast-double, and the Bias-corrected and accelerated bootstrapping as described
in Elbayoumi and Mostafa (2023).
}
\examples{
# Generating Non-contaminated normal BAR(1) tree and calculating the bias corrected
# standard normal CI for the autoregressive coefficients of the BAR(1) model
# Note that in this example (B=2) for speeding up the calculations.
# B must be set to 499 or more for calculation accuracy.
z <- bfa.tree.gen(15, 1, 1, 1, -0.9, -0.9, 0, 10, c(-0.5))
bfa.ls.bc.ci(z, p=1, method="boot1", B=2)
}
\references{
Elbayoumi, T. M. & Mostafa, S. A. (2023). Impact of Bias Correction
of the Least Squares Estimation on Bootstrap Confidence Intervals for Bifurcating
Autoregressive Models. \emph{Journal of Data Science}, 1-20, doi.org/10.6339/23-JDS1092.
}
