% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bib2df_tidy.R
\name{bib2df_tidy}
\alias{bib2df_tidy}
\title{Tidy a bib2df tibble.}
\usage{
bib2df_tidy(bib)
}
\arguments{
\item{bib, }{resulting from \code{bib2df_gather()}.}
}
\value{
A tibble.
}
\description{
\code{bib2df_tidy()} aims to tidy a tibble resulting from \code{bib2df_gather()}.
}
\details{
If multiple Authors or Editors are supplied, the respective character string is split up into a list. The year of publication is converted to \code{as.numeric()}. The \code{CATEGORY} column moves to the very left of the tibble.
}
\examples{
path <- system.file("extdata", "biblio.bib", package = "bib2df")
bib <- bib2df_read(path)
bib <- bib2df_gather(bib)
bib <- bib2df_tidy(bib)
bib
}
\author{
Philipp Ottolinger
}

