% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_fetches.R
\name{custom_fetches}
\alias{custom_fetches}
\alias{.fetch_pollplayers}
\alias{.fetch_pollage}
\alias{.fetch_polllanguage}
\alias{.fetch_ranks_gms}
\alias{.fetch_ranks_cllctn}
\alias{.fetch_bestplayers}
\alias{.fetch_recplayers}
\alias{.fetch_notrecplayers}
\title{Custom fetching methods for non-scalar variables}
\usage{
.fetch_pollplayers(xml)

.fetch_pollage(xml)

.fetch_polllanguage(xml)

.fetch_ranks_gms(xml)

.fetch_ranks_cllctn(xml)

.fetch_bestplayers(xml)

.fetch_recplayers(xml)

.fetch_notrecplayers(xml)
}
\arguments{
\item{xml}{an XML nodeset.}
}
\value{
Type of output might be different for every variable.
}
\description{
This methods are written for more complicated structures (called variables
here) that can't be contained into a simple atomic vector. They are called by
name within \code{.fetch_internal}.
}
\section{Functions}{
\itemize{
\item \code{.fetch_pollplayers()}: Method for pollplayers of bggGames.

\item \code{.fetch_pollage()}: Method for pollage of bggGames.

\item \code{.fetch_polllanguage()}: Method for polllanguage of bggGames.

\item \code{.fetch_ranks_gms()}: Method for ranks of bggGames.

\item \code{.fetch_ranks_cllctn()}: Method for ranks of bggCollection.

\item \code{.fetch_bestplayers()}: Method for bestplayers of bggGames.

\item \code{.fetch_recplayers()}: Method for recplayers of bggGames.

\item \code{.fetch_notrecplayers()}: Method for bestplayers of bggGames.

}}
\keyword{internal}
