% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicWhittle_MCMC_zigzag.R
\name{bdp_dw_mcmc}
\alias{bdp_dw_mcmc}
\title{MH sampler for BDP-DW method}
\usage{
bdp_dw_mcmc(
  data,
  m,
  likelihood_thinning = 1,
  mcmc_params,
  prior_params,
  monitor = FALSE,
  print_interval = 100
)
}
\arguments{
\item{data}{numeric vector.}

\item{m}{window size needed to calculate moving periodogram.}

\item{likelihood_thinning}{the thinning factor of the dynamic Whittle likelihood.}

\item{mcmc_params}{a list generated by \link{bdp_dw_mcmc_params_gen}.}

\item{prior_params}{a list generated by \link{bdp_dw_prior_params_gen}.}

\item{monitor}{a Boolean value (default FALSE) indicating whether to display the real-time status}

\item{print_interval}{If monitor = TRUE, then this value indicates the number of iterations after which a status is printed to console;
If monitor = FALSE, it does not have any effect}
}
\value{
list containing the following fields:

   \item{k1,k2,tau,V,W1,W2}{posterior traces of PSD parameters}
   \item{tim}{total run time}
   \item{prior_params}{the specifications of the prior}
}
\description{
Obtain samples of the posterior of the Whittle likelihood in conjunction with a Bernstein-Dirichlet prior on the spectral density.
}
\details{
Further detail can be found in the simulation study section in the references papers.
}
\references{
Y. Tang et al. (2023)
\emph{Bayesian nonparametric spectral analysis of locally stationary processes}
ArXiv preprint
<arXiv:2303.11561>
}
\keyword{internal}
