% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bexy.R
\name{plotAutosomalTrisomyCounts}
\alias{plotAutosomalTrisomyCounts}
\title{Plotting the autosomal trisomies: counts on that scaffold}
\usage{
plotAutosomalTrisomyCounts(
  x,
  scaffoldName,
  colors = c("deepskyblue4", "darkred"),
  sampleNamesToHighlight = c(),
  label = TRUE,
  ...
)
}
\arguments{
\item{x}{A bexy object.}

\item{scaffoldName}{The name of the scaffold to plot (has to be an autosome)}

\item{colors}{A vector of length two with the colors for diploid and triploid samples, respectively.}

\item{sampleNamesToHighlight}{A vector of sample names that should be highlighted. If empty, samples are automatically highlighted based on the posterior probabilites.}

\item{label}{Boolean indicating whether samples should be labeled.}

\item{...}{Other parameters used for plotting.}
}
\value{
No return value, called for side effects.
}
\description{
Plotting the autosomal trisomies: counts on that scaffold
}
\examples{
bex <- bexy()
plotAutosomalTrisomyCounts(bex, "21")
}
\seealso{
\code{\link{bexy}}
}
