% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_std_selected_lavaan.R
\name{print.lav_betaselect}
\alias{print.lav_betaselect}
\title{Print a 'lav_betaselect' Object}
\usage{
\method{print}{lav_betaselect}(
  x,
  ...,
  nd = 3,
  output = c("lavaan.printer", "table"),
  standardized_only = TRUE,
  show_Bs.by = FALSE,
  by_group = TRUE,
  na_str = " ",
  sig_stars = TRUE,
  ci_sig = TRUE
)
}
\arguments{
\item{x}{A \code{lav_betaselect}-class
object, such as the output of
\code{\link[=lav_betaselect]{lav_betaselect()}}.}

\item{...}{Optional arguments to be
passed to \code{\link[=print]{print()}} methods.}

\item{nd}{The number of digits
after the decimal place. Default
is 3.}

\item{output}{String. How the results
are printed. Default is \code{"lavaan.printer"},
and the results will be
printed in a format similar to
the printout of the output of
the \code{summary}-method of a
'lavaan'-class object.
If set to \code{"table"}, the results are
printed in a table
format similar to that of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}
with \code{output} set to \code{"data.frame"}.}

\item{standardized_only}{Logical.
If \code{TRUE}, the default, only the
results for the standardized solution
will be printed. If \code{FALSE},
then
the standardized solution is printed
alongside the unstandardized solution,
as in the printout of the output
of \code{\link[=summary]{summary()}} of a 'lavaan'-class
object.}

\item{show_Bs.by}{Logical. If \code{TRUE}
and \code{output} is \code{"lavaan.printer"}, then the
column \code{"Bs.by"} is shown,
indicating, for each parameter, the
variables standardized.
This column is not shown if \code{output}
is not \code{"lavaan.printer"}.}

\item{by_group}{If \code{TRUE}, the
default, and the model has more than
one group, sections will be grouped
by groups first, as in the print
out of \code{summary()} in \code{lavaan}.
If \code{FALSE}, then the sections will
be grouped by sections first.}

\item{na_str}{The string to be used
for cells with \code{NA}. Default is
\code{" "}, a whitespace.}

\item{sig_stars}{If \code{TRUE}, the
default, symbols such as asterisks
(\code{*}, \verb{**}, \verb{***}) will be used to
denote whether a beta-select is
significant.}

\item{ci_sig}{If \code{TRUE}, the default,
a beta-select will be denoted as
significant or not significant based
on its confidence interval.}
}
\value{
\code{x} is returned invisibly. Called for its side effect.
}
\description{
Print method for a
'lav_betaselect' object, which
is the output of
\code{\link[=lav_betaselect]{lav_betaselect()}}.
}
\details{
The default format of the printout,
\code{"lavaan.printer"},
is similar to that of the \code{summary()}
of a \code{lavaan} object.
Users can also select whether
only the standardized solution is
printed or whether
the standardized solution is appended
to the right of the printout.

If \code{output} is set to \verb{"table"' the format is that of [lavaan::parameterEstimates()] with }output = "data.frame"`,
which is compact but not easy to
read.
}
\examples{
library(lavaan)
mod <-
"
med ~ iv + mod + iv:mod
dv ~ med + iv
"
fit <- sem(mod,
           data_test_medmod,
           fixed.x = TRUE)
summary(fit)
fit_beta <- lav_betaselect(fit,
                           to_standardize = c("iv", "dv"))
fit_beta
print(fit_beta)
print(fit_beta, show_Bs.by = TRUE)
print(fit_beta, output = "table")

}
\seealso{
\code{\link[=lav_betaselect]{lav_betaselect()}}. This
function is adapted from
\code{\link[semhelpinghands:print.std_solution_boot]{semhelpinghands::print.std_solution_boot()}}.
}
\author{
Shu Fai Cheung
\url{https://orcid.org/0000-0002-9871-9448}
}
