% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{dBetaBinom}
\alias{dBetaBinom}
\title{Probability Mass under the Beta-Binomial Probability-Mass Distribution.}
\usage{
dBetaBinom(x, N, l, u, alpha, beta)
}
\arguments{
\item{x}{Value of \code{x} (a specific number of successes).}

\item{N}{The total number of trials.}

\item{l}{The first (lower) location parameter.}

\item{u}{The second (upper) location parameter.}

\item{alpha}{The first shape parameter.}

\item{beta}{The second shape parameter.}
}
\value{
The value for the probability mass at \code{x} given the specified Beta-Binomial distribution.
}
\description{
Gives the density at \code{x} under the Beta-Binomial PMF.
}
\examples{
# Assume some variable follows a Beta-Binomial distribution with 100 number
# of trials, and with probabilities of successful trials drawn from a four-
# parameter Beta distribution with location parameters l = 0.25 and u = 0.75
# and shape parameters alpha = 5 and beta = 3. To compute the probability
# density at a specific point of the distribution (e.g., 50):
dBetaBinom(x = 50, N = 100, l = 0.25, u = 0.75, alpha = 5, beta = 3)
}
