% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaMC-s-cor-mc.R
\name{SCorMC}
\alias{SCorMC}
\title{Estimate Semipartial Correlation Coefficients
and Generate the Corresponding Sampling Distribution
Using the Monte Carlo Method}
\usage{
SCorMC(object)
}
\arguments{
\item{object}{Object of class \code{mc}, that is,
the output of the \code{MC()} function.}
}
\value{
Returns an object
of class \code{betamc} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{object}{The function argument \code{object}.}
\item{thetahatstar}{Sampling distribution of
\eqn{r_{s}}.}
\item{vcov}{Sampling variance-covariance matrix of
\eqn{r_{s}}.}
\item{est}{Vector of estimated
\eqn{r_{s}}.}
\item{fun}{Function used ("SCorMC").}
}
}
\description{
Estimate Semipartial Correlation Coefficients
and Generate the Corresponding Sampling Distribution
Using the Monte Carlo Method
}
\details{
The vector of semipartial correlation coefficients
(\eqn{r_{s}})
is derived from each randomly generated vector of parameter estimates.
Confidence intervals are generated by obtaining
percentiles corresponding to \eqn{100(1 - \alpha)\%}
from the generated sampling
distribution of \eqn{r_{s}},
where \eqn{\alpha} is the significance level.
}
\examples{
# Fit the regression model
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
# Generate the sampling distribution of parameter estimates
# (use a large R, for example, R = 20000 for actual research)
mc <- MC(object, R = 100)
# Generate confidence intervals for standardized regression slopes
rs <- SCorMC(mc)
# Methods --------------------------------------------------------
print(rs)
summary(rs)
coef(rs)
vcov(rs)
confint(rs, level = 0.95)
}
\seealso{
Other Beta Monte Carlo Functions: 
\code{\link{BetaMC}()},
\code{\link{DeltaRSqMC}()},
\code{\link{DiffBetaMC}()},
\code{\link{MC}()},
\code{\link{PCorMC}()},
\code{\link{RSqMC}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Monte Carlo Functions}
\keyword{betaMC}
\keyword{scor}
