% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaMethod-methods.R
\name{print.deltamethod}
\alias{print.deltamethod}
\title{Print Method for an Object of Class \code{deltamethod}}
\usage{
\method{print}{deltamethod}(x, alpha = NULL, digits = 4, ...)
}
\arguments{
\item{x}{Object of class \code{deltamethod}.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.
If \code{alpha = NULL},
use the argument \code{alpha} used in \code{x}.}

\item{digits}{Digits to print.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of
coefficients,
standard errors,
test statistics,
degrees of freedom (if z = FALSE),
p-values,
and
confidence intervals.
}
\description{
Print Method for an Object of Class \code{deltamethod}
}
\examples{
object <- glm(
  formula = vs ~ wt + disp,
  family = "binomial",
  data = mtcars
)
def <- list("exp(wt)", "exp(disp)")
out <- DeltaGeneric(
  object = object,
  def = def,
  alpha = 0.05
)
print(out)

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
