% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupHist.R
\name{groupHist}
\alias{groupHist}
\title{Histogram for classes}
\usage{
groupHist(
  df,
  x,
  g,
  xlab = "",
  ylab = "",
  breaks = 20,
  las = 1,
  main = NULL,
  unit = NA,
  ...
)
}
\arguments{
\item{df}{data.frame object name}

\item{x}{column name of variable of interest}

\item{g}{column name of groups (\code{INDEX in \link{tapply}, f in \link{split}})}

\item{xlab, ylab}{axis labels. DEFAULT: ""}

\item{breaks}{\code{\link{hist} breaks}. DEFAULT: 20}

\item{las}{LabelAxisStyle, see \code{\link{par}}. DEFAULT: 1, means numbers on y-axis upright}

\item{main}{Main title, internal default based on \code{d, x, unit} and \code{g}. DEFAULT: NULL}

\item{unit}{Unit to be written into the default title. DEFAULT: NA}

\item{\dots}{further arguments passed to \code{\link{hist}}}
}
\value{
NULL, used for plotting
}
\description{
Improvement of \code{tapply(x, g, hist)} with x and g taken from a data.frame
}
\details{
Uses \code{\link{split}} to categorize into groups.
}
\examples{

groupHist(chickwts, weight, "feed", col="salmon")
groupHist(chickwts, "weight", "feed", col=2, unit="grams at age 6 weeks")
groupHist(chickwts, weight, feed, col="khaki", breaks=5, main="Hi there")
groupHist(iris, Petal.Width, Species)

}
\seealso{
\code{\link{hist}}, \code{\link{tapply}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jan 2015
}
\keyword{distribution}
\keyword{dplot}
\keyword{hplot}
