% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l2array.R
\name{l2array}
\alias{l2array}
\title{Convert list of arrays to array}
\usage{
l2array(x, usenames = TRUE, checknames = TRUE)
}
\arguments{
\item{x}{List with arrays. The dimension of the first is target dimension.}

\item{usenames}{Logical: Should names be kept? The names of the first element 
will be used. DEFAULT: TRUE}

\item{checknames}{Logical: Should names of other elements be the same as in x[[1]]?
Will be checked with useful warning messages. DEFAULT: TRUE}
}
\value{
array
}
\description{
Convert a list of arrays to a single array, conserving names
}
\examples{
A1 <- array(1:24, dim=c(4,2,3), dimnames=list(
                   my_x=paste0("row",1:4), my_y=c("A","B"), paste0("n",1:3)))
A1
# Selection:
A1[,,"n2"]
A1["row2",,] # result rotated against expectation
A1[,"A",]
# aggregation:
apply(A1, MARGIN=1:2, FUN=sum) # keep first two dimensions
apply(A1, MARGIN=c(1,3), FUN=sum) # aggregate over my_y -> row1: 6, 22, 38
A1["row1",,]                                    # 1+5=6, 9+13=22, 17+21=38

as.vector(A1)
A2 <- A1+2
A3 <- A1+4

LA <- list(A1=A1, A2=A2, A3=A3) # list of arrays

AA <- l2array(LA)
AA
AA[,,,"A2"]
avg <- apply(AA, MARGIN=1:3, mean)
stopifnot(all(avg==A2))

# names check:
LN <- LA
names(dimnames(LN[[2]]))[3] <- "intentional"
dimnames(LN[[2]])[3] <- list(paste0("k",1:3))
AN <- l2array(LN)

LN <- LA
rownames(LN[[3]])[2] <- "intentional_diff"
A <- l2array(LN)

# data type check
A <- l2array(c(LA, 999))


}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Dec 2016
}
\seealso{
\code{\link{l2df}}, \code{\link{help}}
}
\keyword{array}
\keyword{list}
\keyword{manip}

