% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark.R
\name{mark}
\alias{mark}
\alias{bench_mark}
\title{Benchmark a series of functions}
\usage{
mark(..., min_time = 0.5, iterations = NULL, min_iterations = 1,
  max_iterations = 10000, check = TRUE, filter_gc = TRUE,
  relative = FALSE, env = parent.frame())
}
\arguments{
\item{...}{Expressions to benchmark, if named the \code{expression} column will
be the name, otherwise it will be the deparsed expression.}

\item{min_time}{The minimum number of seconds to run each expression, set to
\code{Inf} to always run \code{max_iterations} times instead.}

\item{iterations}{If not \code{NULL}, the default, run each expression for
exactly this number of iterations. This overrides both \code{min_iterations}
and \code{max_iterations}.}

\item{min_iterations}{Each expression will be evaluated a minimum of \code{min_iterations} times.}

\item{max_iterations}{Each expression will be evaluated a maximum of \code{max_iterations} times.}

\item{check}{Check if results are consistent. If \code{TRUE}, checking is done
with \code{\link[=all.equal]{all.equal()}}, if \code{FALSE} checking is disabled. If \code{check} is a
function that function will be called with each pair of results to
determine consistency.}

\item{filter_gc}{If \code{TRUE} filter iterations that contained at least one
garbage collection before summarizing.}

\item{relative}{If \code{TRUE} all summaries are computed relative to the minimum
execution time rather than absolute time.}

\item{env}{The environment which to evaluate the expressions}
}
\value{
A \link[tibble:tibble]{tibble} with the additional summary columns.
The following summary columns are computed
\itemize{
\item \code{min} - \code{bench_time} The minimum execution time.
\item \code{mean} - \code{bench_time} The arithmetic mean of execution time
\item \code{median} - \code{bench_time} The sample median of execution time.
\item \code{max} - \code{bench_time} The maximum execution time.
\item \code{mem_alloc} - \code{bench_bytes} Total amount of memory allocated by running the expression.
\item \code{itr/sec} - \code{integer} The estimated number of executions performed per second.
\item \code{n_itr} - \code{integer} Total number of iterations after filtering
garbage collections (if \code{filter_gc == TRUE}).
\item \code{n_gc} - \code{integer} Total number of garbage collections performed over all runs.
}
}
\description{
Benchmark a list of quoted expressions. Each expression will always run at
least twice, once to measure the memory allocation and store results and one
or more times to measure timing.
}
\examples{
dat <- data.frame(x = runif(100, 1, 1000), y=runif(10, 1, 1000))
mark(
  min_time = .1,

  dat[dat$x > 500, ],
  dat[which(dat$x > 500), ],
  subset(dat, x > 500))
}
\seealso{
\code{\link[=press]{press()}} to run benchmarks across a grid of parameters.
}
