% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zibellreg.R
\name{zibellreg}
\alias{zibellreg}
\title{ZiBell regression model}
\usage{
zibellreg(
  formula,
  data,
  approach = c("mle", "bayes"),
  hessian = TRUE,
  hyperpars = list(mu_psi = 0, sigma_psi = 10, mu_beta = 0, sigma_beta = 10),
  ...
)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which ypbp is called.}

\item{approach}{approach to be used to fit the model (mle: maximum likelihood; bayes: Bayesian approach).}

\item{hessian}{hessian logical; If TRUE (default), the hessian matrix is returned when approach="mle".}

\item{hyperpars}{a list containing the hyperparameters associated with the prior distribution of the regression coefficients; if not specified then default choice is hyperpars = c(mu_psi = 0, sigma_psi = 10, mu_beta = 0, sigma_beta = 10).}

\item{...}{further arguments passed to either `rstan::optimizing` or `rstan::sampling`.}
}
\value{
zibellreg returns an object of class "zibellreg" containing the fitted model.
}
\description{
Fits the Bell regression model to overdispersed count data.
}
\examples{
\donttest{
# ML approach:
mle <- zibellreg(cells ~ smoker+gender|smoker+gender, data = cells, approach = "mle")
summary(mle)

# Bayesian approach:
bayes <- zibellreg(cells ~ 1|smoker+gender, data = cells, approach = "bayes")
summary(bayes)
}

}
