% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/site_model_to_xml_prior.R
\name{site_model_to_xml_prior_distr}
\alias{site_model_to_xml_prior_distr}
\title{Internal function}
\usage{
site_model_to_xml_prior_distr(site_model, beauti_options)
}
\arguments{
\item{site_model}{a site model,
as returned by \code{\link{create_site_model}}}

\item{beauti_options}{one BEAUti options object,
as returned by \code{\link{create_beauti_options}}}
}
\value{
the site model as XML text
}
\description{
Converts a site model to XML,
  used in the \code{prior} section
}
\examples{
site_model_to_xml_prior_distr(
  site_model = create_jc69_site_model(id = 1),
  beauti_options = create_beauti_options()
)
site_model_to_xml_prior_distr(
  site_model = create_hky_site_model(
    id = 1,
    kappa_prior_distr = create_uniform_distr(id = 2)
  ),
  beauti_options = create_beauti_options()
)
site_model_to_xml_prior_distr(
  site_model = create_tn93_site_model(
    id = 1,
    kappa_1_prior_distr = create_uniform_distr(id = 2),
    kappa_2_prior_distr = create_uniform_distr(id = 3)
  ),
  beauti_options = create_beauti_options()
)
site_model_to_xml_prior_distr(
  site_model = create_gtr_site_model(
    id = 1,
    rate_ac_prior_distr = create_uniform_distr(id = 2),
    rate_ag_prior_distr = create_uniform_distr(id = 3),
    rate_at_prior_distr = create_uniform_distr(id = 4),
    rate_cg_prior_distr = create_uniform_distr(id = 5),
    rate_gt_prior_distr = create_uniform_distr(id = 6)
  ),
  beauti_options = create_beauti_options()
)
}
\author{
Richèl J.C. Bilderbeek
}
