% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_inference_model.R
\name{create_inference_model}
\alias{create_inference_model}
\title{Create a Bayesian phylogenetic inference model.}
\usage{
create_inference_model(
  site_model = beautier::create_jc69_site_model(),
  clock_model = beautier::create_strict_clock_model(),
  tree_prior = beautier::create_yule_tree_prior(),
  mrca_prior = NA,
  mcmc = beautier::create_mcmc(),
  beauti_options = beautier::create_beauti_options(),
  tipdates_filename = NA
)
}
\arguments{
\item{site_model}{a site model,
as returned by \code{\link{create_site_model}}}

\item{clock_model}{a clock model,
as returned by \code{\link{create_clock_model}}}

\item{tree_prior}{a tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{mrca_prior}{a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{mcmc}{one MCMC.
Use \code{\link{create_mcmc}} to create an MCMC.
Use \code{\link{create_ns_mcmc}} to create an MCMC
  for a Nested Sampling run.
Use \code{\link{check_mcmc}} to check if an MCMC is valid.
Use \code{\link{rename_mcmc_filenames}} to rename the filenames in an MCMC.}

\item{beauti_options}{one BEAUti options object,
as returned by \code{\link{create_beauti_options}}}

\item{tipdates_filename}{name of the file containing the tip dates.
This file is assumed to have two columns, separated by a tab.
The first column contains the taxa names, the second column contains
the date.}
}
\value{
an inference model
}
\description{
Create a Bayesian phylogenetic inference model,
as can be done by BEAUti.
}
\examples{
if (is_on_ci()) {

  check_empty_beautier_folder()

  # Create an MCMC chain with 50 states
  inference_model <- create_inference_model(
    mcmc = create_mcmc(chain_length = 50000, store_every = 1000)
  )

  output_filename <- get_beautier_tempfilename()
  create_beast2_input_file_from_model(
    input_filename = get_fasta_filename(),
    output_filename = output_filename,
    inference_model = inference_model
  )
  file.remove(output_filename)

  remove_beautier_folder()
  check_empty_beautier_folder()
}
}
\seealso{
Use \link{create_test_inference_model} to create an inference model
with a short MCMC, to be used in testing.
Use \link{create_ns_inference_model} to create an inference model
to estimate the marginal likelihood
(aka evidence) using a nested sampling approach.
}
\author{
Richèl J.C. Bilderbeek
}
