% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ns_inference_model.R
\name{create_ns_inference_model}
\alias{create_ns_inference_model}
\title{Create an inference model to measure the evidence of.}
\usage{
create_ns_inference_model(
  site_model = beautier::create_jc69_site_model(),
  clock_model = beautier::create_strict_clock_model(),
  tree_prior = beautier::create_yule_tree_prior(),
  mcmc = beautier::create_ns_mcmc()
)
}
\arguments{
\item{site_model}{a site model,
as returned by \code{\link{create_site_model}}}

\item{clock_model}{a clock model,
as returned by \code{\link{create_clock_model}}}

\item{tree_prior}{a tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{mcmc}{one MCMC.
Use \code{\link{create_mcmc}} to create an MCMC.
Use \code{\link{create_ns_mcmc}} to create an MCMC
  for a Nested Sampling run.
Use \code{\link{check_mcmc}} to check if an MCMC is valid.
Use \code{\link{rename_mcmc_filenames}} to rename the filenames in an MCMC.}
}
\value{
an inference model
}
\description{
Create an inference model to measure the evidence of.
To do so, the inference model is created as usual (see
\link{create_inference_model}), except
for using a Nested Sampling MCMC (see \link{create_ns_mcmc})
}
\examples{
check_empty_beautier_folder()

inference_model <- create_ns_inference_model()

check_empty_beautier_folder()
}
\seealso{
Use \link{create_inference_model} to create a
regular  inference model.
Use \link{create_test_ns_inference_model} to create an inference model
to estimate the marginal likelihood with a short MCMC,
to be used in testing.
}
\author{
Richèl J.C. Bilderbeek
}
