% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clock_model_to_xml_tracelog.R
\name{clock_model_to_xml_tracelog}
\alias{clock_model_to_xml_tracelog}
\title{Internal function}
\usage{
clock_model_to_xml_tracelog(
  inference_model,
  clock_model = "deprecated",
  mrca_priors = "deprecated"
)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}

\item{clock_model}{a clock model,
as returned by \code{\link{create_clock_model}}}

\item{mrca_priors}{a list of one or more Most Recent Common Ancestor priors,
as returned by \code{\link{create_mrca_prior}}}
}
\value{
a character vector of XML strings
}
\description{
Creates the clock model's XML for the tracelog section
}
\examples{
check_empty_beautier_folder()

# <logger id="tracelog" ...>
#'   # Here
# </logger>

check_empty_beautier_folder()
}
\seealso{
all clock models' tracelog section is created
  by \code{\link{clock_models_to_xml_tracelog}}
}
\author{
Richèl J.C. Bilderbeek
}
