% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_mrca_prior.R
\name{init_mrca_prior}
\alias{init_mrca_prior}
\title{Initialize the MRCA prior.}
\usage{
init_mrca_prior(input_filename, inference_model)
}
\arguments{
\item{input_filename}{A FASTA filename.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
an initialized MRCA prior
}
\description{
Initialized by
\itemize{
  \item if no alignment ID is set,
    it is set by reading it from the alignment file
  \item if no taxa names are set,
    these are set by reading these from the alignment file
}
}
\author{
Richèl J.C. Bilderbeek
}
