% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_laplace_distr}
\alias{create_laplace_distr}
\alias{create_distr_laplace}
\title{Create a Laplace distribution}
\usage{
create_laplace_distr(id = NA, mu = 0, scale = 1)
}
\arguments{
\item{id}{the distribution's ID}

\item{mu}{the mu parameter,
a numeric value.
For advanced usage, use the structure
as returned by \code{\link{create_mu_param}}}

\item{scale}{the scale parameter,
a numeric value.
For advanced usage, use the structure
as returned by \code{\link{create_scale_param}}}
}
\value{
a Laplace distribution
}
\description{
Create a Laplace distribution
}
\examples{
  laplace_distr <- create_laplace_distr()

  beast2_input_file <- tempfile(fileext = ".xml")
  create_beast2_input_file(
    input_filename = get_fasta_filename(),
    beast2_input_file,
    tree_prior = create_yule_tree_prior(
      birth_rate_distr = laplace_distr
    )
  )
  testit::assert(file.exists(beast2_input_file))
}
\seealso{
the function \code{\link{create_distr}} shows an overview
  of all supported distributions
}
\author{
Richèl J.C. Bilderbeek
}
