% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_params_doc.R
\name{default_params_doc}
\alias{default_params_doc}
\title{Documentation of general function arguments.
This function does nothing.
It is intended to inherit function argument documentation.}
\usage{
default_params_doc(alignment_id, bd_tree_prior, cbs_tree_prior,
  beauti_options, ccp_tree_prior, cep_tree_prior, chain_length,
  clock_model, clock_model_name, clock_model_names, clock_models,
  clock_prior_distr_id, crown_age, crown_ages, distr_id, fasta_filename,
  fasta_filenames, fixed_crown_age, fixed_crown_ages, gamma_site_model,
  group_sizes_dimension, gtr_site_model, has_non_strict_clock_model,
  has_tip_dating, hky_site_model, id, ids, inference_model,
  inference_models, initial_phylogenies, input_filename, input_filenames,
  is_monophyletic, jc69_site_model, log_every, mcmc, mode, mrca_prior,
  mrca_priors, mrca_prior_name, n_init_attempts, output_filename, param_id,
  phylogeny, posterior_crown_age, pre_burnin, rln_clock_model,
  sample_from_prior, sanitise_headers, screenlog, sequence_length,
  site_model, site_model_name, site_model_names, site_models, sort,
  store_every, strict_clock_model, taxa_names, tipdates_filename,
  tn93_site_model, tracelog, treelog, tree_prior, tree_prior_name,
  tree_prior_names, tree_priors, verbose, yule_tree_prior)
}
\arguments{
\item{alignment_id}{ID of the alignment,
as returned by \link{get_alignment_id}.
Keep at \code{NA} to have it initialized automatically}

\item{bd_tree_prior}{a Birth-Death tree prior, as created
by \code{\link{create_bd_tree_prior}}}

\item{cbs_tree_prior}{a Coalescent Bayesian Skyline tree prior,
as returned by \code{\link{create_cbs_tree_prior}}}

\item{beauti_options}{one BEAUti options object,
as returned by \code{\link{create_beauti_options}}}

\item{ccp_tree_prior}{a Coalescent Constant Population tree prior,
as returned by \code{\link{create_ccp_tree_prior}}}

\item{cep_tree_prior}{a Coalescent Exponential Population tree prior,
as returned by \code{\link{create_cep_tree_prior}}}

\item{chain_length}{length of the MCMC chain}

\item{clock_model}{a clock model,
as returned by \code{\link{create_clock_model}}}

\item{clock_model_name}{name of a clock model,
must be a name as returned by \code{\link{get_clock_model_names}}}

\item{clock_model_names}{one or more names of a clock model,
must be name among those returned by \code{\link{get_clock_model_names}}}

\item{clock_models}{a list of one or more clock models,
as returned by \code{\link{create_clock_model}}}

\item{clock_prior_distr_id}{ID of an MRCA clock model's distribution.
Keep at \code{NA} to have it initialized automatically}

\item{crown_age}{the crown age of the phylogeny}

\item{crown_ages}{the crown ages of the phylogenies. Set to NA
if the crown age needs to be estimated}

\item{distr_id}{a distributions' ID}

\item{fasta_filename}{a FASTA filename.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{fasta_filenames}{One or more FASTA filenames.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{fixed_crown_age}{determines if the phylogeny's crown age is
fixed. If FALSE, crown age is estimated by BEAST2. If TRUE,
the crown age is fixed to the crown age
of the initial phylogeny.}

\item{fixed_crown_ages}{one or more booleans to determine if the
phylogenies' crown ages are fixed.
If FALSE, crown age is estimated by BEAST2. If TRUE,
the crown age is fixed to the crown age
of the initial phylogeny.}

\item{gamma_site_model}{a site model's gamma site model,
as returned by \code{\link{create_gamma_site_model}}}

\item{group_sizes_dimension}{the group sizes' dimension, as used
by the CBS tree prior (see \code{\link{create_cbs_tree_prior}})}

\item{gtr_site_model}{a GTR site model,
as returned by \code{\link{create_gtr_site_model}}}

\item{has_non_strict_clock_model}{boolean to indicate that the is
already at least one non-strict (i.e. relaxed log-normal) clock model}

\item{has_tip_dating}{TRUE if the user has supplied tip dates,
FALSE otherwise}

\item{hky_site_model}{an HKY site model,
as returned by \code{\link{create_hky_site_model}}}

\item{id}{an alignment's IDs.
An ID can be extracted from its FASTA filename
with \code{\link{get_alignment_ids_from_fasta_filenames}})}

\item{ids}{one or more alignments' IDs.
IDs can be extracted from their FASTA filenames
with \code{\link{get_alignment_ids_from_fasta_filenames}})}

\item{inference_model}{an Bayesian phylogenetic inference model,
as can be created by \code{\link{create_inference_model}}.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.}

\item{inference_models}{a list of one or more inference models,
as can be created by \link{create_inference_model}}

\item{initial_phylogenies}{one or more MCMC chain's initial phylogenies.
Each one set to \code{NA} will result in BEAST2 using a random phylogeny.
Else the phylogeny is assumed to be of class \link[ape]{phylo}}

\item{input_filename}{A FASTA filename.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{input_filenames}{One or more FASTA filenames.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{is_monophyletic}{boolean to indicate monophyly is assumed in
a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{jc69_site_model}{a JC69 site model,
as returned by \code{\link{create_jc69_site_model}}}

\item{log_every}{number of MCMC states between writing to file}

\item{mcmc}{one MCMC
as returned by \code{\link{create_mcmc}}}

\item{mode}{mode how to log.
Valid values are the ones returned by \link{get_log_modes}}

\item{mrca_prior}{a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{mrca_priors}{a list of one or more Most Recent Common Ancestor priors,
as returned by \code{\link{create_mrca_prior}}}

\item{mrca_prior_name}{the unique name of the MRCA prior,
for example a genus, family,
order or even class name.
Leave at \link{NA} to have it named automatically.}

\item{n_init_attempts}{number of initialization attempts before failing}

\item{output_filename}{Name of the XML parameter file created by this
function. BEAST2 uses this file as input.}

\item{param_id}{a parameter's ID}

\item{phylogeny}{a phylogeny of type \link[ape]{phylo}}

\item{posterior_crown_age}{deprecated}

\item{pre_burnin}{number of burn in samples taken before entering
the main loop}

\item{rln_clock_model}{a Relaxed Log-Normal clock model,
as returned by \code{\link{create_rln_clock_model}}}

\item{sample_from_prior}{set to \link{TRUE} to sample from the prior}

\item{sanitise_headers}{set to \link{TRUE} to sanitise the headers of the
log file}

\item{screenlog}{a \code{screenlog},
as created by \link{create_screenlog}}

\item{sequence_length}{a DNA sequence length, in base pairs}

\item{site_model}{a site model,
as returned by \code{\link{create_site_model}}}

\item{site_model_name}{name of a site model,
must be a name as returned by \code{\link{get_site_model_names}}}

\item{site_model_names}{one or more names of a site model,
must be name among those returned by \code{\link{get_site_model_names}}}

\item{site_models}{one or more site models,
as returned by \code{\link{create_site_model}}}

\item{sort}{how to sort the log.
Valid values are the ones returned by \link{get_log_sorts}}

\item{store_every}{number of states the MCMC will process
before the posterior's state will be saved to file.
Use -1 or \code{NA} to use the default frequency.}

\item{strict_clock_model}{a strict clock model,
as returned by \code{\link{create_strict_clock_model}}}

\item{taxa_names}{names of the taxa,
as returned by \code{\link{get_taxa_names}}.
Keep at \code{NA} to have it initialized automatically,
using all taxa in the alignment}

\item{tipdates_filename}{name of the file containing the tip dates.
This file is assumed to have two columns, separated by a tab.
The first column contains the taxa names, the second column contains
the date.}

\item{tn93_site_model}{a TN93 site model,
as returned by \code{\link{create_tn93_site_model}}}

\item{tracelog}{a \code{tracelog},
as created by \link{create_tracelog}}

\item{treelog}{a \code{treelog},
as created by \link{create_treelog}}

\item{tree_prior}{a tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{tree_prior_name}{name of a tree prior,
must be a name as returned by \code{\link{get_tree_prior_names}}}

\item{tree_prior_names}{one or more names of a tree prior,
must be a name among those returned by \code{\link{get_tree_prior_names}}}

\item{tree_priors}{one or more tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{verbose}{if TRUE, additional information is displayed, that
is potentially useful in debugging}

\item{yule_tree_prior}{a Yule tree_prior,
as created by \code{\link{create_yule_tree_prior}}}
}
\description{
Documentation of general function arguments.
This function does nothing.
It is intended to inherit function argument documentation.
}
\note{
This is an internal function, so it should be marked with
  \code{@noRd}. This is not done, as this will disallow all
  functions to find the documentation parameters
}
\author{
Richèl J.C. Bilderbeek
}
