% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastas_to_phylos.R
\name{fastas_to_phylos}
\alias{fastas_to_phylos}
\title{Create a random phylogeny, with the same taxa names as the FASTA file
  and the desired crown age}
\usage{
fastas_to_phylos(fasta_filenames, crown_age)
}
\arguments{
\item{fasta_filenames}{One or more FASTA filenames.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{crown_age}{the crown age of the phylogeny}
}
\value{
a a random phylogy, with the same taxa names as the FASTA file
  and the desired crown age
}
\description{
Create a random phylogeny, with the same taxa names as the FASTA file
  and the desired crown age
}
\examples{
  # Create two random phylogies, with
  # - the same taxa names as the FASTA files
  # - the desired crown age
  fasta_filenames <- get_beautier_paths(
    c("anthus_aco.fas", "anthus_nd2.fas")
  )
  initial_phylogenies <- fastas_to_phylos(
    fasta_filenames,
    crown_age = 15
   )

  # Crown age fixed to the crown age of the phylogeny
  create_beast2_input_file_1_12(
    input_filenames = fasta_filenames,
    "fastas_to_phylos.xml",
    fixed_crown_ages = c(TRUE, TRUE),
    initial_phylogenies = initial_phylogenies
  )
  testthat::expect_true(file.exists("fastas_to_phylos.xml"))
}
