% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_param.R
\name{create_sigma_param}
\alias{create_sigma_param}
\alias{create_param_sigma}
\title{Create a parameter called sigma}
\usage{
create_sigma_param(id = NA, estimate = FALSE, value = 1)
}
\arguments{
\item{id}{the parameter's ID}

\item{estimate}{TRUE if this parameter alpha be estimated by BEAST2,
FALSE otherwise}

\item{value}{value of the parameter}
}
\value{
a parameter called sigma
}
\description{
Create a parameter called sigma
}
\note{
this parameter is used in a normal distribution
  (as returned by \code{\link{create_normal_distr}})
}
\examples{
  # Create the parameter
  sigma_param <- create_sigma_param()

  # Use the parameter in a distribution
  normal_distr <- create_normal_distr(
    sigma = sigma_param
  )

  # Use the distribution to create a BEAST2 input file
  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "create_sigma_param.xml",
    tree_priors = create_yule_tree_prior(
      birth_rate_distr = normal_distr
    )
  )
  testit::assert(file.exists("create_sigma_param.xml"))
}
\seealso{
the function \code{\link{create_param}} contains a list
  of all parameters that can be created
}
\author{
Richel J.C. Bilderbeek
}
