% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mrca_prior.R
\name{create_mrca_prior}
\alias{create_mrca_prior}
\title{Create a Most Recent Common Ancestor prior}
\usage{
create_mrca_prior(alignment_id, taxa_names, is_monophyletic = FALSE,
  mrca_distr = NA, name = NA, clock_prior_distr_id = NA)
}
\arguments{
\item{alignment_id}{ID of the alignment,
as returned by \code{\link{get_alignment_id}}}

\item{taxa_names}{names of the taxa,
as returned by \code{\link{get_taxa_names}}}

\item{is_monophyletic}{boolean to indicate monophyly is assumed in
a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{mrca_distr}{the distribution used by the MRCA prior.
Can be NA (the default) or any distribution
returned by \code{\link{create_distr}}}

\item{name}{the unique name of the MRCA prior, for example a genus, family,
order or even class name. Leave at NA to have it named automatically}

\item{clock_prior_distr_id}{ID of an MRCA clock model's distribution.
Keep at NA to have it initialized automatically}
}
\value{
an MRCA prior
}
\description{
Create a Most Recent Common Ancestor prior
}
\author{
Richel J.C. Bilderbeek
}
