% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{robustify_mvnorm}
\alias{robustify_mvnorm}
\title{Robustify Multivariate Normal Distributions}
\usage{
robustify_mvnorm(prior, n, weights = c(0.5, 0.5))
}
\arguments{
\item{prior}{Multivariate Normal distributional object}

\item{n}{Number of theoretical participants (or events, for time-to-event data)}

\item{weights}{Vector of weights, where the first number corresponds to the
informative component and the second is the vague}
}
\value{
mixture distribution
}
\description{
Adds vague normal component, where the level of vagueness is controlled by
the \code{n} parameter
}
\details{
In cases with a time-to-event endpoint, a robust mixture prior can be
created by adding a vague multivariate normal component to any multivariate
normal prior with mean vector \eqn{\boldsymbol{\mu}} and covariance matrix
\eqn{\boldsymbol{\Sigma}}. The vague component is calculated to have the
same mean vector \eqn{\boldsymbol{\mu}} and covariance matrix equal to
\eqn{\boldsymbol{\Sigma} \times n}, where \code{n} is the specified number of
theoretical events.
}
\examples{
library(distributional)
robustify_mvnorm(
      dist_multivariate_normal(mu = list(c(1, 0)), sigma = list(c(10, 5))),
       n = 15)
}
