% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_bin_path.R
\name{is_bin_path}
\alias{is_bin_path}
\title{Is the path a path to the BEAST2 binary file?
Does not check if the file at that path is present}
\usage{
is_bin_path(path)
}
\arguments{
\item{path}{a string to a path}
}
\value{
TRUE if the path is a path to a BEAST2 binary file
}
\description{
Is the path a path to the BEAST2 binary file?
Does not check if the file at that path is present
}
\examples{
  library(testthat)

  if (is_beast2_installed()) {
    expect_true(is_bin_path("beast"))
    expect_true(is_bin_path("BEAST.exe"))
    expect_false(is_bin_path("beast.jar"))
    expect_true(is_bin_path(get_default_beast2_bin_path()))
    expect_false(is_bin_path(get_default_beast2_jar_path()))
  }
}
\author{
Richèl J.C. Bilderbeek
}
