% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beakr.R
\name{Beakr}
\alias{Beakr}
\title{Beakr Application class}
\description{
A \code{Beakr} object defines the server instance utilizing the
\pkg{httpuv} package. This class defines an interface for the rest of the
\pkg{beakr} package and is therefore meant to be instantiated.
}
\section{Methods}{

\describe{
  \item{\code{router()}}{
  An instantiated \code{Router} object.
  }
  \item{\code{server()}}{
  The instantiated \code{Server} object.
  }
  \item{\code{appDefinition()}}{
  A method to define the functions or middleware of users application.
  }
  \item{\code{initialize()}}{
  Creates a new \code{Router} object for the \code{router}
  method.
  }
  \item{\code{start(host, port, daemon)}}{
  Returns a running server. If \code{daemon = TRUE}, the server will run
  in the background.
  }
  \item{\code{print(...)}}{
  Returns a console output of the instance and its number of middleware
  attached.
  }
}
}

\section{Package details}{


The \pkg{beakr} package provides a minimal web framework for for developing
lightweight APIs in R. The package includes basic functionality for handling
common \code{HTTP} requests. \pkg{beakr} is a ground-up rewrite and
continuation of the \pkg{jug} package developed by Bart Smeets. The
\pkg{beakr} package is supported and maintained by
\href{http://www.mazamascience.com/}{Mazama Science}.
}

\seealso{
\code{\link{Router}} and \code{\link{Middleware}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-appDefinition}{\code{Beakr$appDefinition()}}
\item \href{#method-new}{\code{Beakr$new()}}
\item \href{#method-start}{\code{Beakr$start()}}
\item \href{#method-print}{\code{Beakr$print()}}
\item \href{#method-clone}{\code{Beakr$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-appDefinition"></a>}}
\if{latex}{\out{\hypertarget{method-appDefinition}{}}}
\subsection{Method \code{appDefinition()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Beakr$appDefinition()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Beakr$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-start"></a>}}
\if{latex}{\out{\hypertarget{method-start}{}}}
\subsection{Method \code{start()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Beakr$start(host, port, daemon)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Beakr$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Beakr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
