% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdsvd.R
\name{bdsvd}
\alias{bdsvd}
\title{Block Detection Using Singular Vectors (BD-SVD).}
\usage{
bdsvd(X, dof.lim, standardize = TRUE, max.iter, trace = FALSE)
}
\arguments{
\item{X}{Data matrix of dimension \eqn{n x p} with possibly \eqn{p >> n}.}

\item{dof.lim}{Interval limits for the number of non-zero components in the sparse loading (degrees of freedom).
If \eqn{S} denotes the support of \eqn{v}, then the cardinality of the support, \eqn{|S|},
corresponds to the degrees of freedom. Default is \code{dof.lim <- c(0, p-1)} which is highly recommended to check for
all levels of sparsity.}

\item{standardize}{Standardize the data to have unit variance. Default is \code{TRUE}.}

\item{max.iter}{How many iterations should be performed for computing the sparse loading.
Default is \code{200}.}

\item{trace}{Print out progress as iterations are performed. Default is \code{TRUE}.}
}
\value{
A list containing the feature names of the submatrices of \code{X}. The length of the list equals
the number of submatrices.
}
\description{
Performs BD-SVD iteratively to reveal the block structure. Splits the data matrix into one (i.e., no split)
or two submatrices, depending on the structure of the first sparse loading \eqn{v} (which is a sparse approximation of the
first right singular vector, i.e., a vector with many zero values) that mirrors the shape of the covariance matrix. This
procedure is continued iteratively until the block diagonal structure has been revealed.

The data matrix ordered according to this revealed block diagonal structure can be obtained by \link{bdsvd.structure}.
}
\details{
The sparse loadings are computed using the method by Shen & Huang (2008), implemented in
the \code{irlba} package.
}
\examples{
#Replicate simulation study (c) from Bauer (202Xa) with different values for b:

p <- 500 #Number of variables
n <- 250 #Number of observations
b <- 2   #Number of blocks (b <- 10 in Bauer (202Xa))
design <- "c" #Simulation design "a", "b", "c", or "d".

#Simulate data matrix X
set.seed(1)
Sigma <- bdsvd.cov.sim(p = p, b = b, design = design)
X <- mvtnorm::rmvnorm(n, mean = rep(0, p), sigma = Sigma)
colnames(X) <- 1:p

bdsvd(X, standardize = FALSE)

}
\references{
\cite{Bauer, J.O. (202Xa). High-dimensional block diagonal covariance structure detection using singular vectors.}
}
\seealso{
\link{bdsvd.structure}, \link{bdsvd.ht}, \link{single.bdsvd}
}
