% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_space.R
\name{optim_model_space}
\alias{optim_model_space}
\title{Calculation of the model_space object}
\usage{
optim_model_space(
  df,
  timestamp_col,
  entity_col,
  dep_var_col,
  init_value,
  exact_value = FALSE,
  cl = NULL,
  control = list(trace = 2, maxit = 10000, fnscale = -1, REPORT = 100, scale = 0.05)
)
}
\arguments{
\item{df}{Data frame with data for the analysis.}

\item{timestamp_col}{The name of the column with time stamps}

\item{entity_col}{Column with entities (e.g. countries)}

\item{dep_var_col}{Column with the dependent variable}

\item{init_value}{The value with which the model space will be initialized.
This will be the starting point for the numerical optimization.}

\item{exact_value}{Whether the exact value of the likelihood should be
computed (\code{TRUE}) or just the proportional part (\code{FALSE}). Check
\link[bdsm]{sem_likelihood} for details.}

\item{cl}{An optional cluster object. If supplied, the function will use this
cluster for parallel processing. If \code{NULL} (the default),
\code{pbapply::pblapply} will run sequentially.}

\item{control}{a list of control parameters for the optimization which are
passed to \link[stats]{optim}. Default is
\code{list(trace = 2, maxit = 10000, fnscale = -1, REPORT = 100, scale = 0.05)}, but note
that \code{scale} is used only for adjusting the \code{parscale} element added later in the function code.}
}
\value{
List with two objects: \cr
\enumerate{
\item params - table with parameters of all estimated models \cr
\item stats - table with the value of maximized likelihood function, BIC, and
standard errors for all estimated models
}
}
\description{
This function calculates model space, values of the maximized likelihood function, BICs, and
standard deviations of the parameters that will be used in Bayesian model averaging.
}
\examples{
\dontrun{
library(magrittr)

data_prepared <- bdsm::economic_growth[, 1:5] \%>\%
  bdsm::feature_standardization(
    excluded_cols = c(country, year, gdp)
  ) \%>\%
  bdsm::feature_standardization(
    group_by_col  = year,
    excluded_cols = country,
    scale         = FALSE
  )

optim_model_space(
  df            = data_prepared,
  dep_var_col   = gdp,
  timestamp_col = year,
  entity_col    = country,
  init_value    = 0.5
)
}
}
