#' bdclean: Biodiversity Data Cleaning Workflows.
#'
#' Biodiversity Data Cleaning Workflows using R would be helpful
#' to clean biodiversity occurrence data typically downloaded from
#' Global Biodiversity Information Facility (http://www.gbif.org/) or
#' similar biodiversity data portals. There are several data cleaning
#' operations needed to be performed on most of the data downloaded,
#' in order to achieve minimum quality to use the data further for any
#' analysis or modelling.
#'
#' @section Data cleaning:
#' \itemize{
#' \item \link{run_bdclean}
#' \item \link{clean_data}
#' }
#'
#'
#' @section Citation:
#' \itemize{
#' \item Gueta, T., Barve, V., Nagarajah, T., Agrawal, A. & Carmel, Y. (2019). bdclean: Biodiversity data cleaning workflows (R package V 0.1.13). Retrieved from https://github.com/bd-R/bdclean/
#' }
#'
#' @docType package
#' @name bdclean
NULL
