% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryDC.R
\name{summary_DC}
\alias{summary_DC}
\title{Summarise Data Checks}
\usage{
summary_DC(inputFlag, fancy = TRUE, filteringDT = FALSE)
}
\arguments{
\item{inputFlag}{Object of a dataCheckFlag class}

\item{fancy}{Should ouput be returned in a rst format}

\item{filteringDT}{Should output be returned as a summary table that could 
be parsed with a `DT` pacakge}
}
\value{
A data.frame or rst table with summary statistics
}
\description{
`summary_DC()` is a function that calculated statistics for how many data 
checks passed. It's main input is an object of a dataCheckFlag class and output 
is a summary table.
}
\examples{
result <- performDataCheck(dataBats)
# Fancy summary table (for usage in reports)
summary_DC(result)
# object of class used for data filtering data.frame
summary_DC(result, fancy = FALSE, filteringDT = TRUE)

}
