% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis.R
\name{FourierBasis}
\alias{FourierBasis}
\title{Finds the Discrete Fourier Transformation Matrix}
\usage{
FourierBasis(tlist, N, train = NULL)
}
\arguments{
\item{tlist}{an array of the specific points where the basis functions are
evaluated at.}

\item{N}{number of basis functions in the matrix.}

\item{train}{indices corresponding to which rows of the matrix to keep.
Default is to keep all rows.}
}
\value{
A P x N discrete Fourier transformation matrix where P is equal to the
       length of \code{train} and N is the number of basis. If \code{train}
       is \code{NULL} then P equals the length of \code{tlist}.
}
\description{
Uses the package \code{\link{fda}} to find a transformation matrix where the
columns are the different Fourier basis functions, evaluated at specified
points along the rows of the matrix.
}
\examples{
# Points to evaluate the basis functions at
points <- c(0,1,2,3,4)
# Find first 8 Fourier basis functions evaluted at "points"
f <- FourierBasis(points, 8)

# Find first 8 Fourier basis functions evaluated at "points" but only keep
# last two rows
f <- FourierBasis(points, 8, train = c(4,5))
}

