% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cql-geom-predicates.R
\name{bcdc_check_geom_size}
\alias{bcdc_check_geom_size}
\title{Check spatial objects for WFS spatial operations}
\usage{
bcdc_check_geom_size(x)
}
\arguments{
\item{x}{object of class sf, sfc or sfg}
}
\value{
invisibly return logical indicating whether the check pass. If the return
value is TRUE, the object will not need a bounding box drawn. If the return value is
FALSE, the check will fails and a bounding box will be drawn.
}
\description{
Check a spatial object to see if it exceeds the current set value of
'bcdata.max_geom_pred_size' option, which controls how the object is treated when used inside a spatial predicate function in \code{\link[=filter.bcdc_promise]{filter.bcdc_promise()}}. If the object does exceed the size
threshold a bounding box is drawn around it and all features
within the box will be returned. Further options include:
\itemize{
\item Try adjusting the value of the 'bcdata.max_geom_pred_size' option
\item Simplify the spatial object to reduce its size
\item Further processing on the returned object
}
}
\details{
See the \href{https://bcgov.github.io/bcdata/articles/efficiently-query-spatial-data-in-the-bc-data-catalogue.html}{Querying Spatial Data with bcdata}
for more details.
}
\examples{
\donttest{
try({
  airports <- bcdc_query_geodata("bc-airports") \%>\% collect()
  bcdc_check_geom_size(airports)
})
}
}
